<?php

return [
    'name' => 'Contacts',
    'contact_form' => 'Contact form',
    'menu' => 'Contact',
    'edit' => 'View contact',
    'tables' => [
        'phone' => 'Phone',
        'email' => 'Email',
        'full_name' => 'Full Name',
        'time' => 'Time',
        'address' => 'Address',
        'subject' => 'Subject',
        'content' => 'Content',
    ],
    'contact_information' => 'Contact information',
    'replies' => 'Replies',
    'email' => [
        'header' => 'Email',
        'title' => 'New contact from your site',
    ],
    'form' => [
        'name' => [
            'required' => 'Name is required',
        ],
        'email' => [
            'required' => 'Email is required',
            'email' => 'The email address is not valid',
        ],
        'content' => [
            'required' => 'Content is required',
        ],
    ],
    'contact_sent_from' => 'This contact information sent from',
    'sender' => 'Sender',
    'sender_email' => 'Email',
    'sender_address' => 'Address',
    'sender_phone' => 'Phone',
    'message_content' => 'Message content',
    'sent_from' => 'Email sent from',
    'form_name' => 'Name',
    'form_email' => 'Email',
    'form_address' => 'Address',
    'form_subject' => 'Subject',
    'form_phone' => 'Phone',
    'form_message' => 'Message',
    'form_content' => 'Content',
    'required_field' => 'The field with (<span style="color: red">*</span>) is required.',
    'send_btn' => 'Send message',
    'new_msg_notice' => 'You have <span class="bold">:count</span> New Messages',
    'view_all' => 'View all',
    'statuses' => [
        'read' => 'Read',
        'unread' => 'Unread',
    ],
    'phone' => 'Phone',
    'address' => 'Address',
    'message' => 'Message',
    'settings' => [
        'email' => [
            'title' => 'Contact',
            'description' => 'Contact email configuration',
            'templates' => [
                'notice_title' => 'Send notice to administrator',
                'notice_description' => 'Email template for notifying administrator upon receiving a new contact submission',
                'subject' => 'Message sent via contact form at {{ site_title }}',
                'contact_name' => 'Contact name',
                'contact_subject' => 'Contact subject',
                'contact_email' => 'Contact email',
                'contact_phone' => 'Contact phone',
                'contact_address' => 'Contact address',
                'contact_content' => 'Contact content',
                'contact_custom_fields' => 'Custom fields',
                'sender_confirmation_title' => 'Send confirmation to sender',
                'sender_confirmation_description' => 'Email template for confirming the sender that the message has been sent successfully',
                'sender_confirmation_subject' => 'Thank You for Contacting Us!',
                'admin_reply_title' => 'Admin reply to contact',
                'admin_reply_description' => 'Email template for admin replies to contact messages',
                'admin_reply_subject' => 'Re: {{ contact_subject }}',
                'admin_reply_message' => 'Admin reply message',
                'site_title' => 'Site title',
            ],
        ],
        'title' => 'Contact',
        'description' => 'Settings for contact plugin',
        'blacklist_keywords' => 'Blacklisted keywords',
        'blacklist_keywords_placeholder' => 'keywords...',
        'blacklist_keywords_helper' => 'Add contact requests to blacklist if those keywords are found in the content field (separated by comma).',
        'enable_math_captcha_in_contact_form' => 'Enable Math CAPTCHA for contact forms',
        'receiver_emails' => 'Receiver emails',
        'receiver_emails_placeholder' => 'You can enter more than 1 email address (separated by comma)',
        'receiver_emails_helper' => 'Emails from contact forms will be sent to these addresses. To send emails to admin email addresses, leave this field blank.',
        'show_terms_checkbox' => 'Show Terms and Privacy Policy checkbox',
        'show_terms_checkbox_helper' => 'Enable to show the "I agree to the Terms and Privacy Policy" checkbox in the contact form.',
    ],
    'no_reply' => 'No reply yet!',
    'reply' => 'Reply',
    'send' => 'Send',
    'shortcode_name' => 'Contact form',
    'shortcode_description' => 'Add a contact form',
    'shortcode_content_description' => 'Add shortcode [contact-form][/contact-form] to editor',
    'message_sent_success' => 'Message sent successfully!',
    'dropdown_show_label' => 'Show contacts',
    'display_fields' => 'Display fields',
    'mandatory_fields' => 'Mandatory fields',
    'mandatory_fields_helper_text' => 'If left blank, these fields will be validated by default configuration. Name and Message are always mandatory.',
    'custom_field' => [
        'name' => 'Custom Fields',
        'create' => 'Create Custom Field',
        'type' => 'Type',
        'required' => 'Required',
        'placeholder' => 'Placeholder',
        'order' => 'Order',
        'options' => 'Options',
        'option' => [
            'label' => 'Label',
            'value' => 'Value',
            'add' => 'Add new option',
        ],
        'enums' => [
            'types' => [
                'text' => 'Text',
                'number' => 'Number',
                'dropdown' => 'Dropdown',
                'checkbox' => 'Checkbox',
                'radio' => 'Radio',
                'textarea' => 'Textarea',
                'date' => 'Date',
                'datetime' => 'Date time',
                'time' => 'Time',
            ],
        ],
    ],
    'email_templates' => [
        // Admin reply email template
        'admin_reply_title' => 'Reply to Your Contact Message',
        'admin_reply_greeting' => 'Dear :contact_name,',
        'admin_reply_thank_you' => 'Thank you for contacting us. We have reviewed your message and here is our response:',
        'admin_reply_original_message' => 'Your Original Message:',
        'admin_reply_our_response' => 'Our Response:',
        'admin_reply_additional_questions' => 'If you have any additional questions, feel free to reply to this email or contact us again.',
        'admin_reply_best_regards' => 'Best regards,',
        'admin_reply_team' => '{{ site_title }} Team',

        // Notice email template
        'notice_title' => 'New Contact Message',
        'notice_greeting' => 'Dear Admin,',
        'notice_message_details' => 'Message details',
        'notice_reply_instruction' => 'You can reply an email to :contact_email by clicking on below button.',
        'notice_answer_button' => 'Answer',

        // Sender confirmation email template
        'sender_confirmation_title' => 'Thank You for Contacting Us!',
        'sender_confirmation_greeting' => 'Dear :contact_name,',
        'sender_confirmation_thank_you' => 'Thank you for reaching out to us! We have received your message and our team will review it shortly. One of our representatives will get back to you as soon as possible.',
        'sender_confirmation_submission_details' => 'Here are the details of your submission:',
        'sender_confirmation_additional_info' => 'If you have any additional information or questions, feel free to reply to this email.',
        'sender_confirmation_appreciate' => 'We appreciate your interest and will be in touch soon!',

        // Common field labels
        'field_name' => 'Name:',
        'field_subject' => 'Subject:',
        'field_email' => 'Email:',
        'field_address' => 'Address:',
        'field_phone' => 'Phone:',
        'field_content' => 'Content:',
        'field_message' => 'Message:',
    ],
];
